#include <p30fxxxx.h>
#include "ports.h"

/**************************************************************
* Function Name     : CloseINT0
* Description       : Disables external interrupt on pin INT0
* Parameters        : None
* Return Value      : None
**************************************************************/
void CloseINT0(void)
{
    /* Disables external interrupt INT0 */
    IEC0bits.INT0IE = 0;
    IFS0bits.INT0IF = 0;
}
/* end of function CloseINT0 */

/********************************************************************
* Function Name     : ConfigINT0
* Description       : Enables external interrupt on pin INT0.
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/
void ConfigINT0(unsigned int config)
{
    IFS0bits.INT0IF = 0;                       /* clear the interrupt flag */
    IPC0bits.INT0IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT0EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC0bits.INT0IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT0 */

#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__)|| \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__)|| \
    defined(__dsPIC30F2012__) || defined(__dsPIC30F3013__) || defined(__dsPIC30F3014__)|| \
    defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__)|| \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__)|| \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)

/*************************************************************
* Function Name     : CloseINT1
* Description       : Disables external interrupt on pin INT1
* Parameters        : None
* Return Value      : None
**************************************************************/
void CloseINT1(void)
{
    /* Disables external interrupt INT1 */
    IEC1bits.INT1IE = 0;
    IFS1bits.INT1IF = 0;
}
/* end of function CloseINT1 */

/**************************************************************
* Function Name     : CloseINT2
* Description       : Disables external interrupt on pin INT2
* Parameters        : None
* Return Value      : None
***************************************************************/
void CloseINT2(void)
{
    /* Disables external interrupt INT2 */
    IEC1bits.INT2IE = 0;
    IFS1bits.INT2IF = 0;
}
/* end of function CloseINT2 */

/********************************************************************
* Function Name     : ConfigINT1
* Description       : Enables external interrupt on pin INT1.
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/
void ConfigINT1(unsigned int config)
{
    IFS1bits.INT1IF = 0;                       /* clear the interrupt flag */
    IPC4bits.INT1IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT1EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC1bits.INT1IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT1 */

/*******************************************************************
* Function Name     : ConfigINT2
* Description       : Enables external interrupt on pin INT2.
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/
void ConfigINT2(unsigned int config)
{
    IFS1bits.INT2IF = 0;                       /* clear the interrupt flag */
    IPC5bits.INT2IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT2EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC1bits.INT2IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT2 */

#endif

#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__)|| \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__)|| \
    defined(__dsPIC30F6014__)

/**************************************************************************
* Function Name     : CloseINT3
* Description       : Disables external interrupt on pin INT3
* Parameters        : None
* Return Value      : None
*************************************************************************/
void CloseINT3(void)
{
    /* Disables external interrupt INT3 */
    IEC2bits.INT3IE = 0;
    IFS2bits.INT3IF =0;
}
/* end of function CloseINT3 */

/************************************************************
* Function Name     : CloseINT4
* Description       : Disables external interrupt on pin INT4
* Parameters        : None
* Return Value      : None
************************************************************/
void CloseINT4(void)
{
    /* Disables external interrupt INT4 */
    IEC2bits.INT4IE = 0;
    IFS2bits.INT4IF = 0;
}
/* end of function CloseINT4 */

/*******************************************************************
* Function Name     : ConfigINT3
* Description       : Enables external interrupt on pin INT3
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/
void ConfigINT3(unsigned int config)
{
    IFS2bits.INT3IF = 0;                       /* clear the interrupt flag */
    IPC9bits.INT3IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT3EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC2bits.INT3IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT3 */

/*******************************************************************
* Function Name     : ConfigINT4
* Description       : Enables external interrupt on pin INT4.
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Parameters        : config determines falling or rising edge selection
* Return Value      : None
*********************************************************************/
void ConfigINT4(unsigned int config)
{
    IFS2bits.INT4IF = 0;                       /* clear the interrupt flag */
    IPC9bits.INT4IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT4EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC2bits.INT4IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT4 */

#endif

/********************************************************************
* Function Name     : ConfigCNPullups
* Description       : Configures the internal pull-up resistor bits
* Parameters        : None
* Return Value      : None
*********************************************************************/

void ConfigCNPullups(long int config)
{
    CNPU1 = (unsigned int)config;

#if defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || \
    defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)

    CNPU2 = (unsigned int)(config >> 16);

#endif
}
/* end of function ConfigCNPullups */

/********************************************************************
* Function Name     : ConfigIntCN
* Description       : Enables/Disables the individual CN interrupts 
*                     and sets priority and enables/disables CN.
* Parameters        : None
* Return Value      : None
*********************************************************************/

void ConfigIntCN(long int config)
{
    IFS0bits.CNIF = 0;
    CNEN1 = (unsigned int)config;

#if defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || \
    defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)

    CNEN2 = (unsigned int)(config >> 16);

#endif

    config = config >> 24;
    IPC3bits.CNIP = config;
    IEC0bits.CNIE = config >> 3; 
}
/* end of function ConfigIntCN */





